#!/bin/bash

echo "***************************"
echo "Catalog ZeroDay Log4j Fixer"
echo "***************************"

Help() {
   # Display Help
   echo "Helper script to replace log4j jars"
   echo
   echo "Copy this script into a directory and execute"
   echo "Syntax: ./upgrade.sh"
   echo "Provide the component path when asked for"
   echo "eg: For appserver, /opt/ldc/app-server"
   echo "eg: For metadataserver, /opt/ldc/metadata-server"
   echo "eg: For agent, /opt/ldc/agent"
   echo
   echo "Script backs up the old jars into backup directory adjacent to this script"
   echo
}

while getopts ":h" option; do
   case $option in
      h) # display Help
       Help
       exit;;
   esac
done

Process() {
  read -p "Location of component: (Default: /opt/ldc/app-server) " dep_location
  dep_location=${dep_location:-"/opt/ldc/app-server"}
  echo "Location provided: $dep_location"

  echo "Creating a backup directory"
  mkdir -p backup

  echo "Found the following log4j jars: "
  find $dep_location -type f -iregex '.*log4j.*\.jar'

  declare -a jarLocations=(\
  "/lib/log4j-1.2.17.jar" \
  "/lib/logging/log4j-1.2.17.jar" \
  "/lib/dependencies/log4j-1.2.17.jar" \
  "/lib/dependencies/slf4j-log4j12-1.7.25.jar" \
  "/lib/logging/log4j-slf4j18-impl-2.13.3.jar" \
  "/lib/logging/log4j-core-2.13.3.jar" \
  "/lib/logging/log4j-api-2.13.3.jar"\
  "/lib/log4j-api-2.13.3.jar" \
  "/lib/log4j-core-2.13.3.jar" \
  "/lib/log4j-jul-2.13.3.jar" \
  "/lib/log4j-slf4j18-impl-2.13.3.jar" \
  "/lib/logging/log4j-slf4j18-impl-2.15.0.jar" \
  "/lib/logging/log4j-core-2.15.0.jar" \
  "/lib/logging/log4j-api-2.15.0.jar" \
  "/lib/logging/log4j-slf4j18-impl-2.11.2.jar" \
  "/lib/logging/log4j-core-2.11.2.jar" \
  "/lib/logging/log4j-api-2.11.2.jar" )

  echo "Backing up jars"
  for i in "${jarLocations[@]}"
  do
     echo "Backing up $i"
     dirName="backup/"$(dirname $i)
     echo $dirName
     if test -f "$dep_location/$i"; then
        mkdir -p $dirName && cp "$dep_location/$i" backup/$i
        rm -f "$dep_location/$i"
     fi
  done

  if test -d "$dep_location/lib/logging"; then
    cp jars/log4j*.jar $dep_location/lib/logging/
  else
    cp jars/log4j*.jar $dep_location/lib/
  fi
  echo "Upgrade completed"
}

Process